/*****************************************************************************
*
* Copyright 2018-2019 NXP
* All Rights Reserved
*
*****************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************/
#ifndef KERNEL_LIST
#define KERNEL_LIST

#include "sat_acf.h"
#include "sat_box_filter_acf.h"

#ifdef APEX2_EMULATE
extern const int BOX_SIZE;
extern const int BOX_AREA;
#else
const int BOX_SIZE = 5;
const int BOX_AREA = (2 * BOX_SIZE + 1) * (2 * BOX_SIZE + 1);
#endif

KERNEL_INFO kernelInfoConcat(SAT_K) (
	"apu_sat",
   3,
   __port(__index(0),
   __identifier(SAT_KN_IN),
          __attributes(ACF_ATTR_VEC_IN),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d08u),
          __e0_size(1, 1),
          __ek_size(1, 1)),
   __port(__index(1),
    __identifier(SAT_KN_OUT),
          __attributes(ACF_ATTR_VEC_OUT),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d32u),
          __e0_size(1, 1),
          __ek_size(1, 1)),
   __port(__index(2),
   __identifier(SAT_KN_OUT_ROW),
          __attributes(ACF_ATTR_VEC_OUT_STATIC),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d32u),
          __e0_size(1, 1),
          __ek_size(1, 1))
);

KERNEL_INFO kernelInfoConcat(SAT_BOX_FILTER_K)(
  "apu_sat_box_filter",
  2,
  __port(__index(0),
    __identifier(SAT_BOX_FILTER_IN),
    __attributes(ACF_ATTR_VEC_IN),
    __spatial_dep(BOX_SIZE + 1, BOX_SIZE, BOX_SIZE + 1, BOX_SIZE),
    __e0_data_type(d32u),
    __e0_size(1, 1),
    __ek_size(1, 1)),
  __port(__index(1),
  __identifier(SAT_BOX_FILTER_OUT),
    __attributes(ACF_ATTR_VEC_OUT),
    __spatial_dep(0,0,0,0),
    __e0_data_type(d08u),
    __e0_size(1, 1),
    __ek_size(1, 1))
);


#endif
